 ; Ŀ
 ;   Locs - Initial Capital a text file.  Probably a csv.  For Amber.      
 ;   Copyright 2010 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Loco - Initial Capitalize a string.  With exceptions.      
 ;   Arguments: Astr, the string to process.                               
 ;              Iclist, the list of indicator characters - anything after  
 ;                      one of these is capitalized.                       
 ;              Uclist, any string in here is capitalized.                 
 ;                      Allows the wild cards: ? and #.                    
 ;   Calls nothing, returns nothing.  Probably.                            
 ; 
 (DEFUN LOCO (astr iclist uclist / pos match sub prlist nustra nump chra)
  (setq len (strlen astr))
  (setq astr (strcat (substr astr 1 1) (strcase (substr astr 2) t)))
  (setq nustr "")
 ; Ŀ
 ;   Check for substrings (spaces etc.) after which to capitalize.         
 ; 
  (setq pos 1)
  (while (>= len pos)
         (setq chra (substr astr pos 1))
         (if (setq match (stmali (substr astr pos) uclist))
             (progn
                  (setq lenm (strlen match))
                  (setq nustr (strcat nustr (strcase match)))
                  (setq pos (+ pos lenm)))
             (progn
                  (setq nustr (strcat nustr chra))
                  (setq pos (1+ pos)))))
 ; Ŀ
 ;   Check for substrings to capitalize.  Allow the # (number) wild card.  
 ; 
  (setq astr nustr)
  (setq nustr "")
  (setq pos 1)
  (while (>= len pos)
         (setq chra (substr astr pos 1))
         (if (member chra iclist)
             (progn
                  (setq nustr (strcat nustr chra))
                  (setq nustr (strcat nustr
                              (strcase (substr astr (setq pos (1+ pos)) 1)))))
             (setq nustr (strcat nustr chra)))
         (setq pos (1+ pos)))
 nustr)
 ; Ŀ
 ;   Loco end.                                                             
 ; 

 ; Ŀ
 ;   Stmali - see if a string in a list matches the start of a string.     
 ;   Arguments: Stra, the master string.                                   
 ;              Stlist, the list of leading substrings to match.           
 ;                      Allows the wild card "?" - any single character.   
 ;   Calls nothing, returns nil or the match substring.                    
 ; 
 (DEFUN STMALI (stra stlist / num astrc found testr lent)
  (setq num 0)
  (setq astrc (strcase stra))
  (while (and (null found)
              (setq testr (nth num stlist))
              (setq testr (strcase testr)))
         (setq lent (strlen testr))
         (if (wcmatch (substr astrc 1 lent) testr)
             (setq found (substr stra 1 lent)))
         (setq num (1+ num)))
 found)
 ; Ŀ
 ;   Stmali.                                                               
 ; 

 ; Ŀ
 ;   Strite - write a list of strings to a file.                           
 ;   Arguments: Filnam, a filename.                                        
 ;              Strlis, a list of strings.                                 
 ;   Calls nothing.  Returns nothing.                                      
 ; 
 (DEFUN STRITE (filnam strlis / fn linn num)
  (setq fn (open filnam "w"))
  (setq num 0)
  (while (setq linn (nth num strlis))
         (setq num (1+ num))
         (write-line linn fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Strite end.                                                           
 ; 

 ; Ŀ
 ;   Txout - suck a text file into a list of strings.                      
 ;   Arguments: filnam, a filename.                                        
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN TXOUT (filnam / fn linn gnulis)
  (setq fn (open filnam "r"))
  (while (setq linn (read-line fn))
         (setq gnulis (cons linn gnulis)))
  (setq gnulis (reverse gnulis))
  (close fn)
 gnulis)
 ; Ŀ
 ;   Txout end.                                                            
 ; 

 ; Ŀ
 ;   Locs.                                                                 
 ; 
 (DEFUN C:LOCS (/ filnam malist num str gnulis)
 ; Ŀ
 ;   Get a text file.                                                      
 ; 
  (setq filnam (getfiled "File to lowercase" "" "csv" 0))
 ; Ŀ
 ;   Read the file into a list of lists of strings.                        
 ; 
  (setq malist (txout filnam))
 ; Ŀ
 ;   Initial Capitalize each string.                                       
 ; 
  (setq num 0)
  (while (setq str (nth num malist))
         (setq num (1+ num))
         (setq str (loco str (list " " "-" "," "/")
                             (list "#a" "#w" "ddi" "ddo" "avi")))
         (setq gnulis (cons str gnulis)))
  (setq gnulis (reverse gnulis))
 ; Ŀ
 ;   Write the new list out to the new file name.                          
 ; 
  (strite "c:\\out.csv" gnulis)
 ; Ŀ
 ;   End neatly.                                                           
 ; 
 (princ))